%define localstatedir   /var/lib

Summary:            Syslog to iptables dynamic firewall
Name:               syslog2iptables
Version:            1.20
Release:            1%{?dist}
License:            GPLv3+
Group:              System Environment/Daemons
Source:             http://www.five-ten-sg.com/%{name}/packages/%{name}-%{version}.tar.gz
BuildRoot:          %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
URL:                http://www.five-ten-sg.com/%{name}/

Requires:               iptables, coreutils
BuildRequires:          gcc gcc-c++
Requires(pre):          systemd-sysv, shadow-utils
Requires(post):         systemd-units
Requires(preun):        systemd-units
Requires(postun):       systemd-units
Requires:               rsyslog, systemd-units
BuildRequires:          systemd-units


%description
This is a simple adaptive firewall.  It maintains the INPUT chain
of the iptables firewall set based on syslog entries.

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install
install -m 644 -D %{buildroot}%{_sysconfdir}/%{name}.service %{buildroot}%{_unitdir}/%{name}.service
rm -f  %{buildroot}%{_sysconfdir}/%{name}
rm -f  %{buildroot}%{_sysconfdir}/%{name}.service


%clean
rm -rf %{buildroot}


%pre


%post
if [ $1 = 1 ]; then
    # initial install
    /bin/systemctl daemon-reload &>/dev/null || :
    (cd %{_sysconfdir}; ./%{name}.conf.make)
fi

%preun
if [ $1 = 0 ]; then
    # package removal, not upgrade
    /bin/systemctl --no-reload disable %{name}.service &>/dev/null || :
    /bin/systemctl stop %{name}.service &>/dev/null || :
fi


%postun
if [ $1 -ge 1 ]; then
    # package upgrade, not uninstall
    (cd %{_sysconfdir}; ./%{name}.conf.make)
    /bin/systemctl try-restart %{name}.service &>/dev/null || :
fi


%files
%defattr(-,root,root,-)
%{_sbindir}/*
%{_mandir}/man1/*
%{_mandir}/man5/*
%docdir %{_datadir}/doc/%{name}-%{version}
%{_datadir}/doc/%{name}-%{version}
%config(noreplace) %{_sysconfdir}/%{name}.conf.top
%config(noreplace) %{_sysconfdir}/%{name}.conf.httpd
%config(noreplace) %{_sysconfdir}/%{name}.conf.bottom
%attr(750,root,root) %{_sysconfdir}/%{name}.conf.make
%{_unitdir}/%{name}.service


%changelog
* Tue May 27 2025 Carl Byington <carl@five-ten-sg.com> - 1.20-1
- add ssh errors to conf.top for newer Fedora ssh daemon

* Sun Feb 11 2024 Carl Byington <carl@five-ten-sg.com> - 1.19-1
- add error_log to the httpd files

* Wed Jul 15 2020 Carl Byington <carl@five-ten-sg.com> - 1.18-1
- add more logging when blocked addresses move to higher scale values

* Thu Feb 09 2017 Carl Byington <carl@five-ten-sg.com> - 1.17-1
- RHEL7 systemd and /var/run is on tmpfs

* Mon Dec 21 2015 Carl Byington <carl@five-ten-sg.com> - 1.16-3
- fix post uninstall script
- allow config bucket count zero to disable a pattern

* Sat Dec 19 2015 Carl Byington <carl@five-ten-sg.com> - 1.16-2
- fix default config regular expressions

* Sat Dec 19 2015 Carl Byington <carl@five-ten-sg.com> - 1.16-1
- good authentication prevents ip blocking for awhile

* Thu Oct 02 2014 Carl Byington <carl@five-ten-sg.com> - 1.15-1
- add script to build syslog2iptables.conf

* Tue Jun 10 2014 Carl Byington <carl@five-ten-sg.com> - 1.14-1
- Add exponential increase in penalty for repeat offenders.

* Wed Aug 17 2011 Carl Byington <carl@five-ten-sg.com> - 1.13-2
- switch to auto requires

* Sun Jan 25 2009 Carl Byington <carl@five-ten-sg.com> - 1.13-1
- Document multiple contexts.

* Sat Jan 24 2009 Carl Byington <carl@five-ten-sg.com> - 1.12-1
- Allow multiple contexts with independent add/remove commands.

* Thu May 29 2008 Carl Byington <carl@five-ten-sg.com> - 1.11-1
- Fix to compile on Fedora 9 and for const correctness.

* Sat Mar 22 2008 Carl Byington <carl@five-ten-sg.com> - 1.10
- Fix to compile on Solaris.

* Fri Mar 21 2008 Carl Byington <carl@five-ten-sg.com> - 1.9
- changes for Fedora packaging guidelines

* Thu Aug 30 2007 Carl Byington <carl@five-ten-sg.com> - 1.5
- Fix pre/post scripts

* Thu Dec 08 2005 Carl Byington <carl@five-ten-sg.com> - 1.0
- initial revision based on dnsbl spec file
- and http://www.fedora.us/docs/rpm-packaging-guidelines.html
